CREATE TABLE `menu_asignature`(`id_menu_asignature` int NOT NULL AUTO_INCREMENT, `code` varchar(12) NOT NULL, `name` varchar(60) NOT NULL, PRIMARY KEY (`id_menu_asignature`))CHARACTER SET utf8;
CREATE TABLE `menu_college`(`id_menu_college` int NOT NULL AUTO_INCREMENT, `code` varchar(10) NOT NULL, `name` varchar(100) NULL, PRIMARY KEY (`id_menu_college`))CHARACTER SET utf8;
CREATE TABLE `menu_college_asignature`(`id_menu_college_asignature` int NOT NULL AUTO_INCREMENT, `menu_college_id` int NOT NULL, `menu_asignature_id` int NOT NULL, PRIMARY KEY (`id_menu_college_asignature`))CHARACTER SET utf8;
CREATE TABLE `menu_college_rating`(`id_menu_college_rating` int NOT NULL AUTO_INCREMENT, `menu_college_id` int NOT NULL, `menu_asignature_id` int NOT NULL, `menu_student_id` int NOT NULL, `evaluation` date NOT NULL, `note` decimal(4,2) NOT NULL, PRIMARY KEY (`id_menu_college_rating`))CHARACTER SET utf8;
CREATE TABLE `menu_college_student`(`id_menu_college_student` int NOT NULL AUTO_INCREMENT, `menu_college_id` int NOT NULL, `menu_student_id` int NOT NULL, PRIMARY KEY (`id_menu_college_student`))CHARACTER SET utf8;
CREATE TABLE `menu_college_teacher`(`id_menu_college_teacher` int NOT NULL AUTO_INCREMENT, `menu_college_id` int NOT NULL, `menu_teacher_id` int NOT NULL, PRIMARY KEY (`id_menu_college_teacher`))CHARACTER SET utf8;
CREATE TABLE `menu_student`(`id_menu_student` int NOT NULL AUTO_INCREMENT, `code` varchar(12) NOT NULL, `name` varchar(60) NOT NULL, PRIMARY KEY (`id_menu_student`))CHARACTER SET utf8;
CREATE TABLE `menu_teacher`(`id_menu_teacher` int NOT NULL AUTO_INCREMENT, `code` varchar(12) NOT NULL, `name` varchar(60) NOT NULL, PRIMARY KEY (`id_menu_teacher`))CHARACTER SET utf8;
ALTER TABLE `menu_college_asignature` ADD FOREIGN KEY (`menu_asignature_id`) REFERENCES `menu_asignature` (`id_menu_asignature`) ON UPDATE CASCADE ON DELETE NO ACTION;
ALTER TABLE `menu_college_asignature` ADD FOREIGN KEY (`menu_college_id`) REFERENCES `menu_college` (`id_menu_college`) ON UPDATE CASCADE ON DELETE NO ACTION;
ALTER TABLE `menu_college_rating` ADD FOREIGN KEY (`menu_asignature_id`) REFERENCES `menu_asignature` (`id_menu_asignature`) ON UPDATE CASCADE ON DELETE NO ACTION;
ALTER TABLE `menu_college_rating` ADD FOREIGN KEY (`menu_college_id`) REFERENCES `menu_college` (`id_menu_college`) ON UPDATE CASCADE ON DELETE NO ACTION;
ALTER TABLE `menu_college_rating` ADD FOREIGN KEY (`menu_student_id`) REFERENCES `menu_student` (`id_menu_student`) ON UPDATE CASCADE ON DELETE NO ACTION;
ALTER TABLE `menu_college_student` ADD FOREIGN KEY (`menu_college_id`) REFERENCES `menu_college` (`id_menu_college`) ON UPDATE CASCADE ON DELETE NO ACTION;
ALTER TABLE `menu_college_student` ADD FOREIGN KEY (`menu_student_id`) REFERENCES `menu_student` (`id_menu_student`) ON UPDATE CASCADE ON DELETE NO ACTION;
ALTER TABLE `menu_college_teacher` ADD FOREIGN KEY (`menu_college_id`) REFERENCES `menu_college` (`id_menu_college`) ON UPDATE CASCADE ON DELETE NO ACTION;
ALTER TABLE `menu_college_teacher` ADD FOREIGN KEY (`menu_teacher_id`) REFERENCES `menu_teacher` (`id_menu_teacher`) ON UPDATE CASCADE ON DELETE NO ACTION;
SET FOREIGN_KEY_CHECKS = 0;
INSERT INTO `menu_asignature` (`id_menu_asignature`,`code`,`name`) VALUES (1,'AS1','Asignature 1');
INSERT INTO `menu_asignature` (`id_menu_asignature`,`code`,`name`) VALUES (2,'AS2','Asignature 2');
INSERT INTO `menu_asignature` (`id_menu_asignature`,`code`,`name`) VALUES (3,'AS3','Asignature 3');
INSERT INTO `menu_asignature` (`id_menu_asignature`,`code`,`name`) VALUES (4,'AS4','Asignature 4');
INSERT INTO `menu_asignature` (`id_menu_asignature`,`code`,`name`) VALUES (5,'AS5','Asignature 5');
INSERT INTO `menu_asignature` (`id_menu_asignature`,`code`,`name`) VALUES (6,'AS6','Asignature 6');
INSERT INTO `menu_asignature` (`id_menu_asignature`,`code`,`name`) VALUES (7,'AS7','Asignature 7');
INSERT INTO `menu_asignature` (`id_menu_asignature`,`code`,`name`) VALUES (8,'AS8','Asignature 8');
SET FOREIGN_KEY_CHECKS = 1;
SET FOREIGN_KEY_CHECKS = 0;
INSERT INTO `menu_college` (`id_menu_college`,`code`,`name`) VALUES (1,'C1','College 1');
INSERT INTO `menu_college` (`id_menu_college`,`code`,`name`) VALUES (2,'C2','Collge 2');
INSERT INTO `menu_college` (`id_menu_college`,`code`,`name`) VALUES (3,'C3','College 3');
INSERT INTO `menu_college` (`id_menu_college`,`code`,`name`) VALUES (4,'C4','College 4');
SET FOREIGN_KEY_CHECKS = 1;
SET FOREIGN_KEY_CHECKS = 0;
INSERT INTO `menu_college_asignature` (`id_menu_college_asignature`,`menu_college_id`,`menu_asignature_id`) VALUES (1,1,1);
INSERT INTO `menu_college_asignature` (`id_menu_college_asignature`,`menu_college_id`,`menu_asignature_id`) VALUES (2,1,2);
SET FOREIGN_KEY_CHECKS = 1;
SET FOREIGN_KEY_CHECKS = 0;
INSERT INTO `menu_college_rating` (`id_menu_college_rating`,`menu_college_id`,`menu_asignature_id`,`menu_student_id`,`evaluation`,`note`) VALUES (1,1,2,1,'2022-01-02',10.00);
INSERT INTO `menu_college_rating` (`id_menu_college_rating`,`menu_college_id`,`menu_asignature_id`,`menu_student_id`,`evaluation`,`note`) VALUES (2,1,1,4,'2022-01-02',9.25);
SET FOREIGN_KEY_CHECKS = 1;
SET FOREIGN_KEY_CHECKS = 0;
INSERT INTO `menu_college_student` (`id_menu_college_student`,`menu_college_id`,`menu_student_id`) VALUES (1,1,1);
INSERT INTO `menu_college_student` (`id_menu_college_student`,`menu_college_id`,`menu_student_id`) VALUES (2,1,2);
INSERT INTO `menu_college_student` (`id_menu_college_student`,`menu_college_id`,`menu_student_id`) VALUES (3,1,4);
SET FOREIGN_KEY_CHECKS = 1;
SET FOREIGN_KEY_CHECKS = 0;
INSERT INTO `menu_college_teacher` (`id_menu_college_teacher`,`menu_college_id`,`menu_teacher_id`) VALUES (1,1,4);
INSERT INTO `menu_college_teacher` (`id_menu_college_teacher`,`menu_college_id`,`menu_teacher_id`) VALUES (2,1,1);
SET FOREIGN_KEY_CHECKS = 1;
SET FOREIGN_KEY_CHECKS = 0;
INSERT INTO `menu_student` (`id_menu_student`,`code`,`name`) VALUES (1,'ST1','Student 1');
INSERT INTO `menu_student` (`id_menu_student`,`code`,`name`) VALUES (2,'ST2','Student 2');
INSERT INTO `menu_student` (`id_menu_student`,`code`,`name`) VALUES (3,'ST3','Student 3');
INSERT INTO `menu_student` (`id_menu_student`,`code`,`name`) VALUES (4,'ST4','Student 4');
INSERT INTO `menu_student` (`id_menu_student`,`code`,`name`) VALUES (5,'ST5','Student 5');
INSERT INTO `menu_student` (`id_menu_student`,`code`,`name`) VALUES (6,'ST6','Student 6');
INSERT INTO `menu_student` (`id_menu_student`,`code`,`name`) VALUES (7,'ST7','Student 7');
SET FOREIGN_KEY_CHECKS = 1;
SET FOREIGN_KEY_CHECKS = 0;
INSERT INTO `menu_teacher` (`id_menu_teacher`,`code`,`name`) VALUES (1,'T1','Teacher 1');
INSERT INTO `menu_teacher` (`id_menu_teacher`,`code`,`name`) VALUES (2,'T2','Teacher 2');
INSERT INTO `menu_teacher` (`id_menu_teacher`,`code`,`name`) VALUES (3,'T3','Teacher 3');
INSERT INTO `menu_teacher` (`id_menu_teacher`,`code`,`name`) VALUES (4,'T4','Teacher 4');
INSERT INTO `menu_teacher` (`id_menu_teacher`,`code`,`name`) VALUES (5,'T5','Teacher 5');
SET FOREIGN_KEY_CHECKS = 1;
